#!/usr/bin/perl
# STB - Simple Traffic Billing
# Version-0.1.1-beta
# Author: Boo (yolkapalka@bk.ru)

use Time::localtime;
use Fcntl ':flock';

$tm = localtime;
$y = $tm->year + 1900;
$m = $tm->mon + 1;
$d = $tm->mday;
$h = $tm->hour;

$dir = $0;
$dir =~ s/[^\/]{1,}$//;
require "$dir/readcfg.inc";

($mask) = ($localnet =~ /(\d+.\d+).\d+.\d+/);
$net = $mask;

system("/sbin/pfctl -q -Tl -f /etc/pf.conf");

foreach $int (@int_if) {
    open(pid, "<$cnupm_path/cnupm-$int.pid");
    while(<pid>) {
	chomp;
	kill "HUP", $_;
	kill "INFO", $_;
    }
    sleep(10);
    if(open(Dump ,"<$cnupm_path/cnupm-$int.dump")) {
	while(1) {
	    if(flock(Dump, LOCK_EX)) {
		@temp = `/usr/local/sbin/cnupmstat -B -E -P $int`;
		unlink "$cnupm_path/cnupm-$int.dump";
		flock(Dump, LOCK_UN);
		last;
	    }
	}
    }
    close(Dump);

    foreach $string (@temp) {
	push @dump, $string;
    }
}
my @ip;
if (@dump) {
    open(traffic, "+<$stb_path/etc/traffic.ip");
    flock(traffic, LOCK_EX);
    while(<traffic>) {
    	chomp;
    	next unless $_;
    	@t = split(':');
    	$tr_name{$t[1]} = $t[0];
    	push @ip, $t[1];
    	$tr_out{$t[1]} = $t[2];
    	$tr_in{$t[1]} = $t[3];
    	$tr_all_old{$t[1]} = $t[2] + $t[3];
    	$tr_last{$t[1]} = $t[4];
	$last_update{$t[1]} = $t[5];
	$last_traff{$t[1]} = $t[6];
	$last_date{$t[1]} = $t[7];
	$fio{$t[1]} = $t[8];
	$adr{$t[1]} = $t[9];
	$phone{$t[1]} = $t[10];
    }
    foreach $f (@ip) {
	$startcurhour = 0;
	$endcurhour = 0;
    	open(reports, "<$stb_path/reports/$y-$m-$d\_$f");
    	while (<reports>) {
    	    chomp;
    	    next unless $_;
	    if($_ eq "<h=$h>") {
		$startcurhour = 1; next;
	    }
	    if(($startcurhour == 1)and($_ eq "</h>")) {
		$endcurhour = 1; last;
	    }
	    if(($startcurhour == 1)and($endcurhour != 1)) {
    		@t = split(':');
    		$hosts_traff{$f}{$t[0]} = "$t[1]:$t[2]";
	    } else {
		push @{$other_reports{$f}}, $_;
	    }
    	}
    	close(reports);
    }
    open(passip, "<$stb_path/etc/pass.ip");
    while(<passip>) {
	chomp;
	next unless $_;
	push @passip, $_;
    }
    close(passip);
    chomp(@dump);
    foreach $i (@dump) {
    	$i =~ /(\d+.\d+)(.\d+.\d+) (\d+.\d+)(.\d+.\d+) (\w+) (\d+)/;
    	if ($1 eq $net) {
    	    $tr_out{"$1$2"} = $tr_out{"$1$2"} + $6;
    	    @i = split(':', $hosts_traff{"$1$2"}{"$3$4"});
    	    $hout = $i[0] + $6;
	    if ($hout eq "") { $hout = 0; }
	    if ($i[1] eq "") { $i[1] = 0; }
    	    $hosts_traff{"$1$2"}{"$3$4"} = "$hout:$i[1]";
    	} elsif ($3 eq $net) {
    	    $tr_in{"$3$4"} = $tr_in{"$3$4"} + $6;
    	    @i = split(':', $hosts_traff{"$3$4"}{"$1$2"});
    	    $hin = $i[1] + $6;
	    if ($i[0] eq "") { $i[0] = 0; }
	    if ($hin eq "") { $hin = 0; }
    	    $hosts_traff{"$3$4"}{"$1$2"} = "$i[0]:$hin";
    	}
    }
    seek(traffic, 0, 0);
    foreach $i (@ip) {
    	$tr_last{$i} = ($tr_last{$i} - (($tr_in{$i} + $tr_out{$i}) - $tr_all_old{$i}));
    	printf traffic "$tr_name{$i}:$i:$tr_out{$i}:$tr_in{$i}:$tr_last{$i}:$last_update{$i}:$last_traff{$i}:$last_date{$i}:$fio{$i}:$adr{$i}:$phone{$i}\n";
    	foreach $t (@passip) {
    	    if ($t eq $i) {
		$pass = $i;
	    }
	}
    	if ($tr_last{$i} > 0) {
	    if ($pass eq $i) {
		system("/sbin/pfctl -q -t passip -Ta $i");
	    } else {
            	system("/sbin/pfctl -q -t passip -Td $i");
            	system("/sbin/pfctl -q -k $i");
	    }
    	} else {
    	    if ($pass eq $i) {
            	system("/sbin/pfctl -q -t passip -Td $i");
            	system("/sbin/pfctl -q -k $i");
            	open(passip, ">$stb_path/etc/pass.ip");
            	flock(passip, LOCK_EX);
            	foreach $t (@passip) {
            	    if ($t ne $i) {
                    	printf passip "$t\n";
            	    }
            	}
            	flock(passip, LOCK_UN);
            	close(passip);
    	    }
    	}
    }
    flock(traffic, LOCK_UN);
    close(traffic);
    foreach $f (@ip) {
    	%tr = %{$hosts_traff{$f}};
	if((%tr != "")or($other_reports{$f}[0] ne "")) {
	    $no_rep = "0";
	    unless(-e "$stb_path/reports/$y-$m-$d\_$f") {
		$no_rep = "1";
	    }
    	    open(reports, ">$stb_path/reports/$y-$m-$d\_$f") or die "$!\n";
	    flock(reports, LOCK_EX);
	    if($other_reports{$f}[0] ne "") {
		foreach $other_report (@{$other_reports{$f}}) {
		    printf reports "$other_report\n";
		}
	    }
	    if(%tr != "") {
		printf reports "<h=$h>\n";
	    }
    	    foreach $l (sort {$tr{$a} <=> $tr{$b} } keys %tr) {
    		printf reports "$l:$tr{$l}\n";
    	    }
	    if(%tr != "") {
		printf reports "</h>\n";
	    }
	    flock(reports, LOCK_UN);
    	    close(reports);
	    if($no_rep eq "1") {
		my ($uid, $gid) = (getpwnam("$httpd_user"))[2,3];
		chown($uid, $gid, "$stb_path/reports/$y-$m-$d\_$f");
	    }
	}
    }
}